/**
* Script: checkbox.js
* Written by: Radnen
* Updated: 1/5/2011
**/

function CheckBox(parent, x, y, text)
{
	this.inherit = Control;
	this.inherit(parent, x, y, System.textFont.getStringWidth(text)+20, 20);
	
	this.onCheck = function(){};
	this.text = text;
	this.checked = false;
	
	this.update = function() {
		this.updateMouse();
		if (this.entered) {
			if (Cursor.onLeftClick()) {
				this.checked = !this.checked;
				this.onCheck();
			}
		}
	}
	
	this.draw = function() {
		this.x = this.parent.x + this.xx;
		this.y = this.parent.y + this.yy;
		
		Rectangle(this.x, this.y, 16, 16, Colors.black);
		if (this.checked) Resources.images.gui_check.blit(this.x, this.y);
		OutlinedRectangle(this.x, this.y, 16, 16, this.entered ? Colors.green : Colors.gray);
		System.textFont.drawText(this.x+20, this.y, this.text);
	}
}